\version "2.20.0"
\language "english"
\pointAndClickOff
\include "./local_includes/00_beaming_library.ly"
\include "./local_includes/header_paper_blocks.ly"
\paper { first-page-number = 2 }

\header {
  title = \markup {  \pad-to-box #'(0 . 0) #'(-11.9 . 11) \override #'(font-name . "AppleMyungjo") 
                     \fontsize #5 "I. Hoe Cake"                  
  }
}

secondTimeClef = -\markup { {\musicglyph "clefs.G_change" 
  
  \postscript "
  matrix currentmatrix 
  -1.2 0 translate
  1 3 scale
  newpath

  -0.3 0.2 1.5 140 215 arc
  
  2.25 0 rmoveto
  -0.6 0.2 1.5 325 40 arc

  setmatrix
  0 setlinejoin
  0.2 setlinewidth
  stroke
"
}
  \hspace #-4.5 \raise #6.5 \pad-markup #-1
  \override #'(baseline-skip . 2) \smaller 
  \column {
            \left-align \italic (2nd
            \left-align \italic time)
  } 
  }
  


distanceBetweenBeams = \override Beam.length-fraction = #1.2


basicSpaceBetween = \override VerticalAxisGroup.staff-staff-spacing = #'((basic-distance . 12))

bassToTreble = {
  \clef treble
  % Fake staff clef appearance
  \once \override Staff.Clef.glyph-name = #"clefs.F"
  \once \override Staff.Clef.Y-offset = #1
  % Make sure any key signatures will printed with respect to
  % correct middle c position expected for bass clef
  \once \set Staff.middleCClefPosition = 6
  % Append change clef to the time signature
  \once \override Staff.TimeSignature.text = \markup {
    \hspace #1.2
    \lower #1
    \musicglyph #"clefs.G_change"
  }
  \once \override Staff.TimeSignature.stencil = #'(lambda (grob)
    (append-markup grob (ly:time-signature::print grob)))
}

fingPos =
#(define-music-function
  (parser location extra-offset)
  (pair?)
  #{
    \once \override Fingering.extra-offset = #extra-offset
  #})

csr = \change Staff = "rightII"
csl = \change Staff = "leftII"

% variables exclusive to hoe cake
pedPos =
#(define-music-function
  (parser location extra-offset)
  (pair?)
  #{
    \once \override Staff.SustainPedal.extra-offset = #extra-offset
  #})
slurFix_LIII_Bass = \shape #'((0 . -0.5) (-0.2 . -0.2) (-0.2 . 0.2) (0 . 0)) Slur
slurFix_XX_treble = \shape #'((0 . 0) (3 . 0.7) (0 . 0.7) (0 . 0)) Slur
slurFix_LIII_treble = \shape #'((0 . 0.5) (-1 . 1) (1 . 1) (0 . 0)) Slur
slurFix_LVII_treble = \shape #'((0 . -0.5) (-1 . 0) (1 . 0) (0 . -0.5)) Slur
slurFix_LXI_treble = \shape #'((0 . 1) (-1 . 1) (2 . 2) (0 . -0.5)) Slur
slurFix_LXV_treble = \shape #'((0 . 0) (-1 . 1) (2 . 1) (0 . 1)) Slur
slurFix_LXXXIII_treble = \shape #'((0 . 0.4) (0.2 . 0.2) (-0.2 . 0.2) (0 . 0)) Slur
slurFix_LXXXIX_treble = \shape #'((0 . 2) (0.2 . 0) (-0.2 . 0) (0 . 2)) Slur

xxixToxxxBass = { \repeat unfold 2 { r8 \bIIc \slurFix_LIII_Bass <g b>[( <f a> <g b>^.]) } }
xxxiToxxxiiBass = { \repeat unfold 2 { r8 \bIIs \slurFix_LIII_Bass <g c>[( <e a> <g c>^.]) } }
xxixToxxxivBass = { \xxixToxxxBass \xxxiToxxxiiBass \xxixToxxxBass}

globalHoeCake = {
  \key c \major
  \numericTimeSignature
  \time 4/8
  \tempo "Allegro molto" 4=132
  }

right = \relative c''' {
  \globalHoeCake

    \set Score.proportionalNotationDuration = #(ly:make-moment 1/2)
    \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (14)))
      
   % (Y-offset . 20.5)
  
   <<
     \relative c''' {

  \stemNeutral
  \once\hideNotes\slashedGrace { c64 } c4^5 
  \slashedGrace {  \fingPos #'(0.2 . 1) \once \stemUp a8^3_( } g4^.) |
  R1 * 1/2 |
  g,8_._1 a4( c8) |
  <b d>2^3^5 |
 % start volta
 \bar ".|:"
  \stemUp
       c4.^-^4 e8^.^5 |
       b\rest g_. b\rest a_. |
       c4.^- e8^. |
       \stemNeutral b8\rest d^.^1 b8\rest e^.^2 |
       g4.^- a8^. |
       b,\rest d^. b\rest e^. |
       g4.^- a8^. |
       \override Beam.length-fraction = #1.2
       b,\rest \bIch a'16( g \bIIsh a g e d) |
       \stemUp c4.^-^4 e8^. |
       b\rest g_. b\rest a_. |
       c4.\parenthesize^4^- e8^. |
       \stemNeutral b\rest d^.^1 b\rest e^. |
       g4.^- a8^. |
       b,\rest d^. b\rest e^. |
       g4.^- a8^. |
       b,8\rest \slurFix_XX_treble g'4^1( a8 |
       c4 \och a8 g) |
       
       \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (14)))
       e^.^3 d^. c4 |
       \once \override DynamicText.X-offset = 0
       \bIIch e8^.^5 d16( c) \aIIsc a8_. g_. |
       \once \override Staff.MultiMeasureRest.staff-position = 0 
       R1 * 1/2 |
       \slurNeutral
       
       a4_3( g) |
       b8\rest \aIc e,_3[( d e] |
       c4) b'4\rest |  
       \aIIhs c,8_._1[ d_. e_. g_.] | \bar ":|." \pageBreak
     }
     \\
     \relative c'' {
       
       s2 * 4 |
       g8\rest <g a>_2_1 g8\rest q |
       s2 |
       g8\rest q g8\rest q |
       s2 * 2 |
       s2 * 3
       g8\rest q g\rest q |
       s2 |
       g8\rest q g\rest q |
     }
   >>  
  % endvolta
  \set Score.currentBarNumber = #53
  \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (15)))
  \slurFix_LIII_treble
  d,,4._1( e8~ |
  e d4 e8 |
  g4._3 a8~ |
  a c4 a8) |
  \slurFix_LVII_treble d,4.^( e8~ |
  e d4 e8 |
  c2~) |
  c |
  
  \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (14))(Y-offset . 35.6))
             
            %  \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
%              #'((alignment-distances . (14))(Y-offset . 131.3))
  \slurFix_LXI_treble d4._1( e8~ |
  e d4 e8 |
  g4._3 a8_1 |
  \bIIhs c[ e g e]) |
  \slurFix_LXV_treble d4.( e8~ |
  e g,4 a8) |
  c2~ |
  c4 r |\bar "||"\break
  
  <<
    {
      \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((Y-offset . 65.4))
      \stemNeutral \override Rest.staff-position = 0
      \override MultiMeasureRest.staff-position = 0
      r8 \bIIIch <a c e>^2^4^5([ g^.)] r8 | 
      R1 * 1/2 |
      r8 \bIIIch <a c e>([ g^.)] r8 |
      R1 * 1/2 |
      r8 \bIIIsc <b e>^1^4[( d^.^3]) r8 |
      R1 * 1/2 |
      r8 \bIIIsc <b e>[( d^.]) r8 |
      r4 r8 a_._2 |\break
      
      \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((Y-offset . 98.8))
      <e c'>4.^1^4( <g e'>8^.) |
      r g_. r a_. |
      <e c'>4.( <g e'>8^.) |
      r d'^.^1 r e^. |
      \slurFix_LIII_Bass g4.( <f a>8^.) |
      r d,_._1 r e_. |
      \slurFix_LXXXIII_treble g4._( <f a>8_.) |
      r g_._1 r a_. |
      
      \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (14))(Y-offset . 130.7))
      c4^.( c^.) |
      \aIIsc a8_( g) r a_5 |
      e4_._3_( e_.) |
      d8_( c4.) |
      \set fingeringOrientations = #'(left)
      \slurFix_LXXXIX_treble <e-5>4-\markup { \raise #1.5 \italic "meno mosso" } ( 4 |
      \osc <af,-2 d-5>8 c <f,-1 b-3 d-5>4) |
      <e-1 c'-4>2 |
      %\once \override Beam.color = #red
      \grace { \beamPos #'(1.76 . 1.86) g'16^1( a } c8^.^4) r r4 |\bar "|."
      
    }
    \\
    \relative c' {
      s2 * 20 |
      \set fingeringOrientations = #'(left)
      <a-1>2 | 
      s2 * 2 |
      \grace { s16 s } s2 |
      
    }
  >>  
}

left = \relative c'' {
  \globalHoeCake
  
  % to sort out the whole rest, the other ways don't work here need x-offset later
   
 
    \distanceBetweenBeams
    \once \override TextScript.extra-offset = #'(-1 . 5.5)
     \hideNotes\grace { c64-\markup {  \musicglyph "clefs.G_change" } }
     \once \override Score.Clef.X-extent = #'(-3 . 2 )
    \once \hide Staff.Clef \clef treble
    
    \once \override MultiMeasureRest.X-offset = 1
    \once \override MultiMeasureRest.staff-position = 0
    \unHideNotes  
    R1 * 1/2  |
    
   
  \bIIch e8^.^1 d^. c4^. |
  R1 * 1/2 |
  <f, g>2*1/4_1_2\sustainOn s s \pedPos #'(0 . -3) s\sustainOff |
  \aIhc c8_3^\markup { \italic "non legato" } e_1 \aIhc g,_5 e' |
  \aIhc c e \aIhc g, e'
  \aIhc c e \aIhc g, e'
  \aIhc c e \aIhc g, e'
  \aIIhc b_5 <f' g>_1_2 \aIIhc g,_5 <f' g> |
  \repeat unfold 3 { \aIIhc b, <f' g> \aIIhc g, <f' g> } |
  \repeat unfold 4 { \aIhc c e \aIhc g, e' }
  \repeat unfold 4 { \aIIhc b <f' g> \aIIhc g, <f' g> } |
  r <f a>_1_3 r <e g>  |
  r <f a> r <e g>  |
  R1 * 1/2 |
  \aIch e8_._1 d_. c4_. | \clef bass
  r8 <e, g c> r <g c e> |
  \set fingeringOrientations = #'(left)
  r4 <g,-5 b-3 f'-1>( |
  <c e>^2^1) \bIhc g'8^.^3 a^. |
  R1 * 1/2 |
  
  
  % after repeat
  \stemNeutral \override Rest.staff-position = 0
  
  r8 \bIIc \slurFix_LIII_Bass <g b>_1_3[( <f a>_2_4 <g b>^.])
  r8 \bIIc \slurFix_LIII_Bass <g b>[( <f a> <g b>^.])
  r8 \bIIs \slurFix_LIII_Bass <g c>_3_1[( <e a>_5_2 <g c>^.])
  r8 \bIIs \slurFix_LIII_Bass <g c>[( <e a> <g c>^.])
  \xxixToxxxBass
  r8 \bIIIhs c,^._5[ e^. g^.] |
  \bIIch a^.[ g^. e^. g^.] |
  \xxixToxxxivBass |\clef treble
  r \aIIsh a'_._1[ g_. e_.] |
  \osc d_._1 c_._2 \och a_._4 g_. |
  % double bar-line
  \slurNeutral \tieNeutral
  c4._-_3( e8_.) |
  r g,_._5 r a_. |
  c4._-_2( e8_.) |
  r d_._5 r e_. |
  g4.( a8_.) |
  r d,_. r e_. |
  g4.( a8_.)
  r g_. r4 |\clef bass
  
  \bIIIh <c,, g'>8_2_5[ a'_1 q a]
  \repeat unfold 7 { \bIIIh <c, g'>8[ a' q a] } |
  r \bIIIh c^1[ c,^5 c'] |
  \bIch a^2( g) r a^1 |
  e4^.^3( e^.) |
  \once \stemUp d8( c4.) |
  % these sustains need better positioning
  \pedPos #'(1 . 0) <f, c'>2~\sustainOn |
  
  \pedPos #'(0.5 . 1)q4*1/2\sustainOff \pedPos #'(0.3 . 1) s\sustainOn 
  \set tieWaitForNote = ##t
  \pedPos #'(0.7 . 1) g_2^~\sustainOff  \pedPos #'(1.3 . 0.5) s \sustainOn |
  \pedPos #'(0.7 . 0.5) <c, g'>2*1/2\sustainOff \pedPos #'(0 . 0) s\sustainOn |
  \override Fingering.staff-padding = #'()
  \set fingeringOrientations = #'(left)
  \pedPos #'(0.7 . -2) <c''-3 e-1>8^.\sustainOff r r4 |

}

dynamics = { 
  %\override DynamicLineSpanner.staff-padding = #5
  \override DynamicLineSpanner.Y-offset = #-7
  s2 * 2\mf |
  s8 s s s\> |
  s2 |
  s2 * 3\mp |
  
  \override DynamicLineSpanner.Y-offset = #0
  s2 *2 |
  s2\< |
  s\mf |
  s\> |
  \once \override DynamicText.X-offset = 0
  s2 * 2\mp |
  
  s2 * 3 |
  \override DynamicTextSpanner.to-barline = ##t
  s2 * 3\cresc
  s2\f |
  
  %\override DynamicLineSpanner.Y-offset = #-7
  s\dim |
  \once \override DynamicText.X-offset = 0
  s2 * 3\mp |
  s8 s\< s s |
  s2\p |
  s8\< s s s\!|
  
  % PAGE 2
 %\override DynamicLineSpanner.Y-offset = #-7
  s2\mp |
  s\cresc |
  s8 s s s\f |
  s2 |
  s2 * 2\dim |
  \once \override DynamicText.X-offset = -0.5
  s2 * 2\mp |
  
  %\override DynamicLineSpanner.Y-offset = #0
  s2\mp |
  s8 s8 * 7\cresc |
  s2 * 5\f |
  
  s2 * 8\f |
  |
  
  s2 * 7\mp |
  s8\< s s s\! |
  
  s2 * 4\f |
  s2 * 3\p |
  %\once \override DynamicText.Y-offset = 1
  s2\fz  
  
}

\score {
  \new PianoStaff \with {
    instrumentName = ""
  } <<
    \new Staff = "right" \with {
      midiInstrument = "acoustic grand"
      \basicSpaceBetween 
    } \right
    \new Dynamics = "Dynamics_pf" \dynamics
    \new Staff = "left" \with {
      midiInstrument = "acoustic grand"
    } { \clef bass \left }
  >>
  \layout {  }
}

