\version "2.20.0"
\language "english"
\pointAndClickOff
\include "./local_includes/00_beaming_library.ly"
\include "./local_includes/header_paper_blocks.ly"
\paper { first-page-number = 4 }

\header {
  title = \markup {  \pad-to-box #'(0 . 0) #'(-11.9 . 11) \override #'(font-name . "AppleMyungjo") 
                     \fontsize #5 "II. Rabbit Foot"                  
  }
}


distanceBetweenBeams = \override Beam.length-fraction = #1.2

basicSpaceBetween = \override VerticalAxisGroup.staff-staff-spacing = #'((basic-distance . 12))

fingPos =
#(define-music-function
  (parser location extra-offset)
  (pair?)
  #{
    \once \override Fingering.extra-offset = #extra-offset
  #})

csr = \change Staff = "rightII"
csl = \change Staff = "leftII"

% variables exclusive to hoe cake
pedPos =
#(define-music-function
  (parser location extra-offset)
  (pair?)
  #{
    \once \override Staff.SustainPedal.extra-offset = #extra-offset
  #})
slurFix_LIII_Bass = \shape #'((0 . -0.5) (-0.2 . -0.2) (-0.2 . 0.2) (0 . 0)) Slur
slurFix_XX_treble = \shape #'((0 . 0) (3 . 0.7) (0 . 0.7) (0 . 0)) Slur
slurFix_LIII_treble = \shape #'((0 . 0.5) (-1 . 1) (1 . 1) (0 . 0)) Slur
slurFix_LVII_treble = \shape #'((0 . -0.5) (-1 . 0) (1 . 0) (0 . -0.5)) Slur
slurFix_LXI_treble = \shape #'((0 . 1) (-1 . 1) (2 . 2) (0 . -0.5)) Slur
slurFix_LXV_treble = \shape #'((0 . 0) (-1 . 1) (2 . 1) (0 . 1)) Slur
slurFix_LXXXIII_treble = \shape #'((0 . 0.4) (0.2 . 0.2) (-0.2 . 0.2) (0 . 0)) Slur
slurFix_LXXXIX_treble = \shape #'((0 . 2) (0.2 . 0) (-0.2 . 0) (0 . 2)) Slur

xxixToxxxBass = { \repeat unfold 2 { r8 \bIIc \slurFix_LIII_Bass <g b>[( <f a> <g b>^.]) } }
xxxiToxxxiiBass = { \repeat unfold 2 { r8 \bIIs \slurFix_LIII_Bass <g c>[( <e a> <g c>^.]) } }
xxixToxxxivBass = { \xxixToxxxBass \xxxiToxxxiiBass \xxixToxxxBass}

% variables of rabbit foot
rhItoIV =  { \grace { \beamPos #'(2.3 . 2) a8_4( g } \aIIch f_.) d_. f4 |
             \grace { \beamPos #'(2.3 . 2) a8( g } \aIIch f_.) d_. f4 |
             \grace { \beamPos #'(2.3 . 2) a8( g } \aIIch f_.) d_. \aIIcs f8_. g_. |
           }
           
globalRabbitFoot = {
  \key f \major
  \numericTimeSignature
  \time 4/8
  \tempo "Allegretto" 4=120
  }

right = \relative c'' {
  
  \globalRabbitFoot
  \distanceBetweenBeams
    %\set Score.proportionalNotationDuration = #(ly:make-moment 1/4)
    % \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
%              #'((alignment-distances . (14)))
   % (Y-offset . 20.5)
   \newSpacingSection
        \override Score.SpacingSpanner.spacing-increment = #2.4
  \rhItoIV
  \shape #'((-0.8 . 2.5) (0 . 2) (0.7 . 0.5) (0 . 0)) Slur
  a^1( c4^2) c8 |\break
  
  \bIIch f^5( d \bIIIsc c a |
  \aIIch <f a>_3_5 <e g> <d f>4) |
  
  %\once \override Tie.ex
  \aIIIc <f a>8_. q_>~( \aIIIch q16 d <e g>8) |
  f4 r |
  \rhItoIV
  \shape #'((-0.8 . 2.5) (0 . 2) (0.7 . 0.5) (0 . 0)) Slur
  a8^1( c4^2) c8 |
  \shape #'((0 . 0) (0 . 0.5) (0 . 2) (0 . 0.5)) Slur
  \bIIch f( d \bIIIsc c a |
  \bIIhc c d a4) |
  \bIIhc c8^4( d \bIIIcs a c) |
  a4( g) | \bar "||"\break
  
   \set Score.proportionalNotationDuration = #(ly:make-moment 1/4)
     \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
              #'((alignment-distances . (16))(Y-offset . 127.3))
   % (Y-offset . 20.5)
  r8 \bIch a'16^4( g \bIIc f d f8^.) |
  
  \slashedGrace { g8( } 
  \shape #'((0 . -0.5) (0 . -0.5) (0 . -0.5) (0 . -0.5)) PhrasingSlur
  \bIIsc f8.)\( d16 f4\) |
  
  r8 \bIch a16( g \bIIc f d f8^.) |
  \slashedGrace { g8( } d2) |\break \pageBreak
  
     \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
              #'((alignment-distances . (14)))
  r8 \bIch a'16( g \bIIc f d f8^.) |
  \slashedGrace { g8( } 
  \shape #'((0 . -0.5) (0 . -0.5) (0 . -0.5) (0 . -0.5)) PhrasingSlur
  \bIIsc f8.)\( d16 f4\)

  r8 \bIch a16( g \bIIc f d f8^.^3) |
  d4^2( c) |\bar "||" \break
  
     \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
              #'((Y-offset . 32))
  \repeat unfold 2 { \grace { \aIIsc a8( g } \aIIch f_.) d_. f4 } |
  \grace { \aIIsc a8( g } \aIIch f_.) d_. f_. g_. |
  \shape #'((-0.8 . 2.5) (0 . 2) (0.7 . 0.5) (0 . 0)) Slur
  a( c4) c8 |
  \bIIsc f( d \bIIIch c a |
  \aIIsc <f a> <e g> <d f>4) |\break
  
  \set Score.proportionalNotationDuration = #(ly:make-moment 1/4)
     \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
              #'((alignment-distances . (13.6))(Y-offset . 64))
  \aIIIc <f a>8_. q~_>( \aIIIch q16 d <e g>8) |
  f4 r |
  \repeat unfold 2 { \grace { a'8( g } \bIIch f^.) d^. f4 } |
  \grace { a8( g } \bIIch f^.) d^. \bIhc f^. g^. |\break
  a^1( c4) d8 |
  \och f( d \ocs c d^5) |
  \och a8^.^3( g^.) f4 |
  r8 \bIIc d^5[( c d]) |
  \aIIch a_.( g_.) f4 |
  \och a'8^.^4( g^.) f4 |\break
   \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
              #'((alignment-distances . (16)))
  \aIIch a,8_._4( g_.) f4 |
  \och a'8^.( g^.) f4 |
  \bIVhs f,8^1[( bf^2 df^3 f^1]) |
  f'4 <c,, f a>_>~ |
  q2 |
  R1 |\bar "|."
  
    
}

left = \relative c {
  \globalRabbitFoot
  \clef Bass
  \hideNotes \grace { c4 } \unHideNotes
  <f a c>4._1_3_5 <bf d>8_1_2 |
  \repeat unfold 2 { <f a c>4. <bf d>8 } |
  <f a c>4. <bf c>8 |
  <f a c>4 <e a c> |
  <d f a>2 |
  <c a'>4. <c bf'>8 |
  <f a>4_1_2\sustainOn \pedPos #'(2 . 0) f,_5\sustainOff |
  \repeat unfold 3 { <f' a c>4. <bf d>8 } |
  <f a c>4. <e g c>8 |
  <d f a>4 <f a d> |
  <a c e>2 |
  <d f> |
  <<
    \relative c' { 
      <c e> |
      \repeat unfold 7 { g4 f } |
      g e |
    }
    \\
    \relative c' { 
      c4 bf |
      \bIIcs g8_4 <bf d> \bIIhs f_5 q |
      \repeat unfold 6 { \bIIcs g8 <bf d> \bIIhs f q } |
      \bIIcs g q \bIIhs e <bf' c> |
    } 
  >>
  
  \repeat unfold 3 { <f, a c>4. <bf d>8 } |
  <f a c>4. <bf c>8 |
  <f a c>4 <e a c> |
  <d f a>2 |
  <c a'>4. <c bf'>8 |
  <f a>4\sustainOn \pedPos #'(2 . 0) f,\sustainOff |
  <c' a'>4._1_3 f,8_5
  \repeat unfold 3 { <c' a'>4. f,8 } |
  \repeat unfold 2 { <d' a'>4. f,8 |
                     <c' a'>4. f,8 | }
  <ef' a>4. f,8 |
  <d' bf'>4. f,8_5 |
  \bIIhs df'^2[( f^1 bf^3 df^2]) |
  R1 * 1/2 |
  \pedPos #'(0 . -1)
  f,,4\sustainOn <c' f a>^>~ |
  q2 |
  f,,_>~ |
  \pedPos #'(2 . 0) f4\sustainOff r4 |
  
  
  

}

dynamics = { 
  %\override DynamicLineSpanner.staff-padding = #5
  %\override DynamicLineSpanner.Y-offset = #-7
  s2 * 3\mf |
  s8\< s s s\! |
  s2 * 2\f |
 \override DynamicTextSpanner.to-barline = ##t
  s2\dim |
  \once \override DynamicText.X-offset = #0
  s2 * 5\mp |
  s8\< s s s\! |
  \once \override DynamicText.X-offset = #0
  s2 * 2\mf |
  s4\> s\! |
  s2 * 2\mf |
  \once \override DynamicText.X-offset = #0
  s2 * 2\mp |
  s2 * 2\mf |
  s2\mp |
  s8\< s s s\! |
  s2 * 5\mf |
  s4\< s\! |
  s2 * 2\mp |
  s2 * 3\mf |
  s8\< s s s\! |
  s2\f |
  s8\> s s s\! |
  \once \override DynamicText.X-offset = #0
  s2\mf |
  \override TextScript.Y-offset = #-0.3
  s2-\markup { \italic "poco rit." } |
  s2-\markup { \italic "a tempo" } |
  \once \override DynamicLineSpanner.Y-offset = #-6.5
  s2\mp |
  <<
    { s2 | s_\markup { \italic "rit." } | }
    \\
    { 
      \override DynamicLineSpanner.Y-offset = #-8
      \override DynamicTextSpanner.to-barline = ##t
      s2\cresc | s |
      \once \override DynamicText.X-offset = #0
      s2 * 4\ff | }
  >>
  
  
  
  
}

\score {
  \new PianoStaff \with {
    instrumentName = ""
  } <<
    \new Staff = "right" \with {
      midiInstrument = "acoustic grand"
      \basicSpaceBetween 
    } \right
    \new Dynamics = "Dynamics_pf" \dynamics
    \new Staff = "left" \with {
      midiInstrument = "acoustic grand"
    } { \clef bass \left }
  >>
  \layout {  }
}

