beamPos =
#(define-music-function
     (parser location beg-end)
     (pair?)
   #{
     \once \override Beam.positions = #beg-end
   #})
% Concstruction of variable name is in three parts: 
%   1. location (above, on or below staff line <=>)
%   2. name of the staff line (N.B. all lines have line number twice, once for above, once for below. Numbers are roman numerals because scheme doesn't accept integers in variable names 
%   3. a 'pair' data type, expresses the sit, centre, hang pair combinations: there are six.

% Beam location
% a = above middle staff line
% o = middle staff line
% b = below middle staff line

% Staff lines
% I, II, III, IV, V are staff lines

% Beam attachment Location
% h = hang, c = centre, s = sit
% [hang, straddle, sit is a naming convention used by Ted Ross in the art of Music Engraving, Elaine Gould uses hang, centre, sit, and that's what I'll use from this point forward.]

% Examples (in plain English)

% aVIIsc
% "Above the middle line, seven lines up, start-point centre, end-point hang."
%% i.e. in OOP:
%% aVIIch = { "direction": "up", "line-count": 7, "attachment": [ c, h ] }
%% more functional: OOP: 
%% aVIIch = { "direction": 1, "line-count": 7, "attachment": [0, -1] }
%% most functional: aVIIch = [ 1, 7, 0, -1 ]; even 7210

% osc is "At the middle line, start-point and end-point are both centre."
% bIVsh is "Below the middle line, four lines down, start-point sit, end-point hang."

aVIIIs = \beamPos #'(8.3 . 8.3)
aVIIIsc = \beamPos #'(8.3 . 8)
aVIIIsh = \beamPos #'(8.3 . 7.7)
aVIIIcs = \beamPos #'(8 . 8.3)
aVIIIc = \beamPos #'(8 . 8)
aVIIIch = \beamPos #'(8 . 7.7)
aVIIIhs = \beamPos #'(7.7 . 8.3)
aVIIIhc = \beamPos #'(7.7 . 8)
aVIIIh = \beamPos #'(7.7 . 7.7)

aVIIs = \beamPos #'(7.3 . 7.3)
aVIIsc = \beamPos #'(7.3 . 7)
aVIIsh = \beamPos #'(7.3 . 6.7)
aVIIcs = \beamPos #'(7 . 7.3)
aVIIc = \beamPos #'(7 . 7)
aVIIch = \beamPos #'(7 . 6.7)
aVIIhs = \beamPos #'(6.7 . 7.3)
aVIIhc = \beamPos #'(6.7 . 7)
aVIIh = \beamPos #'(6.7 . 6.7)

aVIs = \beamPos #'(6.3 . 6.3)
aVIsc = \beamPos #'(6.3 . 6)
aVIsh = \beamPos #'( 6.3 . 5.7)
aVIcs = \beamPos #'(6 . 6.3)
aVIc = \beamPos #'(6 . 6)
aVIch = \beamPos #'(6 . 5.7)
aVIhs = \beamPos #'(5.7 . 6.3)
aVIhc = \beamPos #'(5.7 . 6)
aVIh = \beamPos #'(5.7 . 5.7)

aVs = \beamPos #'(5.3 . 5.3)
aVsc = \beamPos #'(5.3 . 5)
aVsh = \beamPos #'(5.3 . 4.7)
aVcs = \beamPos #'(5 . 5.3)
aVc = \beamPos #'(5 . 5)
aVch = \beamPos #'(5 . 4.7)
aVhs = \beamPos #'(4.7 . 5.3)
aVhc= \beamPos #'(4.7 . 5)
aVh = \beamPos #'(4.7 . 4.7)

% to here ...
aIVs = \beamPos #'(4.3 . 4.3)
aIVhs = \beamPos #'(3.7 . 4.3)
aIVcs = \beamPos #'(4 . 4.3)

aIVhc = \beamPos #'(3.7 . 4)

aIVsh = \beamPos #'(4.3 . 3.7)
aIVsc = \beamPos #'(4.3 . 4)
aIVch = \beamPos #'(4 . 3.7)

aIVc = \beamPos #'(4 . 4)
aIVh = \beamPos #'(3.7 . 3.7)

aIIIh = \beamPos #'(3.3 . 3.3)
aIIIsh = \beamPos #'(3.3 . 2.7)
aIIIc = \beamPos #'(3 . 3)

aIIIhs = \beamPos #'(2.7 . 3.3)
aIIIcs = \beamPos #'(3 . 3.3)

aIIIch = \beamPos #'(3 . 2.7)

aIIIsc = \beamPos #'(3.3 . 3)
aIIIs = \beamPos #'(3.3 . 3.3)
aIIIhc = \beamPos #'(2.7 . 3)

aIIsc = \beamPos #'(2.3 . 2)
aIIc = \beamPos #'(2 . 2)
aIIsh = \beamPos #'(2.3 . 1.7)

aIIs = \beamPos #'(2.3 . 2.3)
aIIcs = \beamPos #'(2 . 2.3)

aIIch = \beamPos #'(2 . 1.7)

aIIhs = \beamPos #'(1.7 . 2.3)

aIIhc = \beamPos #'(1.7 . 2)
aIIh = \beamPos #'(1.7 . 1.7)

aIs = \beamPos #'(1.3 . 1.3)
aIcs = \beamPos #'(1 . 1.3)
aIsh = \beamPos #'(1.3 . 0.7)
aIc = \beamPos #'(1 . 1)
aIhs = \beamPos #'(0.7 . 1.3)
aIhc = \beamPos #'(0.7 . 1)
aIch = \beamPos #'(1 . 0.7)
aIsc = \beamPos #'(1.3 . 1)
aIh = \beamPos #'(0.7 . 0.7)

os = \beamPos #'(0.3 . 0.3)
osc = \beamPos #'(0.3 . 0)
osh = \beamPos #'(0.3 . -0.3)
ocs = \beamPos #'(0 . 0.3)
oc = \beamPos #'(0 . 0)
och = \beamPos #'(0 . -0.3)
ohs = \beamPos #'(-0.3 . 0.3)
ohc = \beamPos #'(-0.3 . 0)
oh = \beamPos #'(-0.3 . -0.3)

bIs = \beamPos #'(-0.7 . -0.7)
bIhc = \beamPos #'(-1.3 . -1)
bIhs = \beamPos #'(-1.3 . -0.7)
bIsh = \beamPos #'(-0.7 . -1.3)
bIsc = \beamPos #'(-0.7 . -1)
bIcs = \beamPos #'(-1 . -0.7)
bIch = \beamPos #'(-1 . -1.3)
bIc = \beamPos #'(-1 . -1)
bIh = \beamPos #'(-1.3 . -1.3)


bIIs = \beamPos #'(-1.7 . -1.7)
bIIhs = \beamPos #'(-2.3 . -1.7)
bIIch = \beamPos #'(-2 . -2.3)
bIIcs = \beamPos #'(-2 . -1.7)
bIIsc = \beamPos #'(-1.7 . -2)
bIIsh = \beamPos #'(-1.7 . -2.3)
bIIhc = \beamPos #'(-2.3 . -2)
bIIc = \beamPos #'(-2 . -2)
bIIh = \beamPos #'(-2.3 . -2.3)

bIIIs = \beamPos #'(-2.7 . -2.7)
bIIIsh = \beamPos #'(-2.7 . -3.3)

bIIIhs = \beamPos #'(-3.3 . -2.7)

bIIIhc = \beamPos #'(-3.3 . -3)

bIIIc = \beamPos #'(-3 . -3)

bIIIch = \beamPos #'(-3 . -3.3)

bIIIcs = \beamPos #'(-3 . -2.7)
bIIIsc = \beamPos #'(-2.7 . -3)
bIIIh = \beamPos #'(-3.3 . -3.3)

bIVs = \beamPos #'(-3.7 . -3.7)
bIVch = \beamPos #'(-4 . -4.3)
bIVsh = \beamPos #'(-3.7 . -4.3)
bIVc = \beamPos #'(-4 . -4)
bIVhc = \beamPos #'(-4.3 . -4)
bIVcs = \beamPos #'(-4 . -3.7)
bIVhs = \beamPos #'(-4.3 . -3.7)
bIVsc = \beamPos #'(-3.7 . -4)
bIVh = \beamPos #'(-4.3 . -4.3)

bVs = \beamPos #'(-4.7 . -4.7)
bVc = \beamPos #'(-5 . -5)
bVsh = \beamPos #'(-4.7 . -5.3)
bVhc = \beamPos #'(-5.3 . -5)
bVhs = \beamPos #'(-5.3 . -4.7)
bVch = \beamPos #'(-5 . -5.3)
bVcs = \beamPos #'(-5 . -4.7)
bVsc = \beamPos #'(-4.7 . -5)
bVh = \beamPos #'(-5.3 . -5.3)

bVIs = \beamPos #'(-5.7 . -5.7)
bVIc = \beamPos #'(-6 . -6)
bVIsh = \beamPos #'(-5.7 . -6.3)
bVIch = \beamPos #'(-6 . -6.3)
bVIcs = \beamPos #'(-6 . -5.7)
bVIsc = \beamPos #'(-5.7 . -6)
bVIhc = \beamPos #'(-6.3 . -6)
bVIhs = \beamPos #'(-6.3 . -5.7)
bVIh = \beamPos #'(-6.3 . -6.3)

bVIIs = \beamPos #'(-6.7 . -6.7)
bVIIsc = \beamPos #'(-6.7 . -7)
bVIIsh = \beamPos #'(-6.7 . -7.3)
bVIIcs = \beamPos #'(-7 . -6.7)
bVIIc = \beamPos #'(-7 . -7)
bVIIch = \beamPos #'(-7 . -7.3)
bVIIhs = \beamPos #'(-7.3 . -6.7)
bVIIhc = \beamPos #'(-7.3 . -7)
bVIIh = \beamPos #'(-7.3 . -7.3)

bVIIIs = \beamPos #'(-7.7 . -7.7)
bVIIIsc = \beamPos #'(-7.7 . -8)
bVIIIsh = \beamPos #'(-7.7 . -8.3)
bVIIIcs = \beamPos #'(-8 . -7.7)
bVIIIc = \beamPos #'(-8 . -8)
bVIIIch = \beamPos #'(-8 . -8.3)
bVIIIhs = \beamPos #'(-8.3 . -7.7)
bVIIIhc = \beamPos #'(-8.3 . -8)
bVIIIh = \beamPos #'(-8.3 . -8.3)
