% Acknowledgement to "Thomas Morley-2" for sorting out multimeasure rest centering. see:
% http://lilypond.1069038.n5.nabble.com/Undesired-MultiMeasureRest-X-position-when-clef-change-at-end-of-measure-td236524.html

% Acknowledgement to "David Kastrup" answer
% fixed end of piece key change issue with inserting \grace s256 see:
% http://lilypond.1069038.n5.nabble.com/key-change-at-end-of-snippet-td227745.html#d1579941705000-505

\version "2.20.0"
\language "english"
%\pointAndClickOff
\include "./00_beaming_library.ly"
\paper { 
 page-count = 3
 min-systems-per-page = 5
 max-systems-per-page = 6
 ragged-bottom = ##f
 ragged-last-bottom = ##f 
}

\header {
  title = \markup {  \pad-to-box #'(0 . 0) #'(-5 . 6) 
                     \override #'(font-name . "AppleMyungjo") 
                     \fontsize #5 "Levee Dance"
  }
  composer = \markup {
    \column {
              \override #'(word-space . 1.4)
              \override #'(font-name . "Baskerville")
              \justify  \smallCaps { Florence B. Price }
    }
  }

  arranger = \markup { \override #'(font-name . "Baskerville") "Typeset: Owain Evans" }
  copyright = \markup { \override #'(font-name . "Baskerville") 
    \with-url #"https://creativecommons.org/licenses/by-sa/4.0/" { \pad-to-box #'(0 . 0) #'(0 . 5)
      "©2020  Creative Commons Attribution-ShareAlike 4.0 International Public License."
    }
  }
  tagline = \markup { \override #'(font-name . "Baskerville")
    \with-url #"https://lilypond.org/" {
      \rounded-box \pad-to-box #'(0 . 0) #'(0 . 2)
      "Music engraving by LilyPond 2.20.0—www.lilypond.org"
    }
  }
}

distanceBetweenBeams = \override Beam.length-fraction = #1.2

basicSpaceBetween = \override VerticalAxisGroup.staff-staff-spacing = #'((basic-distance . 13))
spaceBetween_xiiPv = \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (12.5)))
             
spaceBetween_xiiiPv = \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (13.5)))
             
spaceBetween_xivPv = \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (14.5)))

fingPos =
#(define-music-function
  (parser location extra-offset)
  (pair?)
  #{
    \once \override Fingering.extra-offset = #extra-offset
  #})

fingOff = \override Staff.Fingering.stencil = #'()
fingOn = \revert Staff.Fingering.stencil

accidOff = \override Staff.Accidental.stencil = #'()
accidOn = \revert Staff.Accidental.stencil

csr = { \change Staff = "right" \stemDown }
csl = { \change Staff = "left" \stemUp }

hairpinWhiteOut = { 
  \once \override Hairpin.layer = 10
  \once \override Hairpin.whiteout = ##t
}

slurShapeBi = \shape #'((0 . -2) (5 . 2.5) (0 . 0) (0 . 0)) Slur
slurShapeBlxxxv = \shape #'((0 . 0) (0 . 0) (0 . 1) (0 . 0.5)) Slur

% Defining vars in the Score scope, to keep the repeated music (rhBi_xii and lhBi_xii), repeating twice
% Using different system layout and a knock-on effect that different slur sizes and beam positions occur.
% I've isolated their use to the Dynamic context.
scoreSlurShapeBiv = \shape #'((0 . 0) (1 . 0.5) (0 . 0.5) (0 . -4)) Score.Slur
scoreSlurShapeBviia = \shape #'((0 . 0) (2 . 0.5) (0 . 0.5) (0 . -0.5)) Score.Slur
scoreSlurShapeBviib = \shape #'((0 . 0) (2 . 0.5) (0 . 0.5) (0 . -0.5)) Score.Slur
scoreSlurShapeBxxxixa = \shape #'((0 . 0) (2 . 0.5) (0 . 0.5) (0 . -0.5)) Score.Slur
scoreSlurShapeBxxxixb = \shape #'((0 . 0) (2 . 0.5) (0 . 0.5) (0 . -1.5)) Score.Slur
scoreSlurShapeBviii = \shape #'((0 . 0) (2 . 0.5) (0 . 0.5) (-0.5 . -4)) Score.Slur
scoreSlurShapeBxxxvi = \shape #'((0 . 0) (2 . 0.5) (0 . 0.5) (-0.5 . -4)) Score.Slur
scoreSlurShapeBxl = \shape #'((0 . 0) (2 . 0.5) (0.5 . -1) (-0.5 . -6)) Score.Slur

scoreSlurShapeBlvi = \shape #'((0 . -8) (1 . 2) (-5 . 0) (-0.5 . 0)) Score.Slur

scoreBeamPos =
#(define-music-function
     (parser location beg-end)
     (pair?)
   #{
     \once \override Score.Beam.positions = #beg-end
   #})
scoreBeamPosAtBxxxix = \scoreBeamPos #'(5.7 . 6.3)
scoreBeamPosAtBxxxx = \scoreBeamPos #'(6.7 . 7.3)
scoreBeamLow = \scoreBeamPos #'(4.7 . 5.3)
scoreBeamHigh = \scoreBeamPos #'(6.7 . 7.3)
%%%%% END OF Score scoped variables

barRestCentre =
\once \override Score.MultiMeasureRest.spacing-pair = #'(staff-bar . staff-bar)

global = {
  \key g \major
  \numericTimeSignature
  \time 4/8
  \tempo "Allegro" 4=116
  }

rhBi_xii = \relative c''' {
  \repeat unfold 2 { r16 \bIsc b8^>^4( g16 \och b a g8) \fingOff } |
  r16 \bIsc b8( g16) \och b16( g a8^.) |
  \fingOn g4 
  
  \bVIIsh
  \fingPos #'(0 . 1) e16^3( \fingPos #'(0 . 0.2) d^2 \csl \fingPos #'(0 . 1.3) b_1 g_3) \csr |
  d'4^2 e16( g8) e16 |
  d8^. d^> e16( g8) e16 |
  d( b \csl \fingPos #'(0 . 1.2) a_1 g_2) \csr b( g \csl e_1 d_2) \csr |
  bf'^3( \fingPos #'(0 . -0.4) g^1 \csl e_1 d_2 \once \override Stem.length = 8.5 bf8_4) \noBeam \csr \stemNeutral e_1 |
  g4_-_3( g_-) |
  \aIIIcs g16( a b8) \aIIIsh a16( g e8) |
  \aIIc g8_. g_> \aIIIsh a16( g e8) |
}
lhBi_xii = \relative c'' {
  \clef treble
  \bIIIhc \slurShapeBi g8_4( 
  \fingPos #'(0.4 . 2.6)<b d>_1_2 \aIIIcs fs q |
  \aIIIcs e_4 q \aIIIhs d_5 q |
  \aIIcs cs <e g> \aIIhs c <d fs> |
  \aIIhs b <d g>) s s |
  \repeat unfold 2 { r \aIIIsh <g b>[ r <e g>] }
  s2 |
  s8 s s r \clef bass |
  
  \set fingeringOrientations = #'(left)
   r8*1/2 s \bIIch <g,-5 b!-3 d-1>8[  r8*1/2 s <g-5 a-4 c-2>8] |
   
  \repeat unfold 2 { r8 \bIIch <g b d>[  r <g a c>]\fingOff }  |
  \fingOn
}
lhBxxxxix = \relative c{ \stemUp <c g'>8_._2_5 \csr <a' c e>^. \csl <c, g'>8_. \csr <a' c e>^. \csl |}

right = \relative c'' {
  \global
  \distanceBetweenBeams
  \once \hideNotes\grace { b64 }
  \rhBi_xii
  
  g4 d'4^2 |
  e4^.^3( e^.) |
  \bIIcs e16( fs g8) \bIIsh fs16( e c8) |
  \bIIc e^. e^> \bIIsh fs16( e c8) |
  e4( g) |
  \once \override Slur.positions = #'(-3 . 0) g,_-( \aIIIch b16 a g8) |
  \aIIIch b16( a g8_.) g4_> |
  \bIIsh e'16^-( d b8) \aIIIch b16( a g8) |
  \aIIIch b16( a g8_.) g4 |
  g'^-^3 \och b16( a g8) |
  \och b16( a g8) g4 |
  \aIIIch b,16_3( a g8) \aIIcs g8_2_.( a_.) |
  g2^\markup {\translate #'(9 . 2) \fontsize #1 \italic "Fine" }\clef bass | \bar "|."\break \pageBreak
  
  \repeat unfold 2 {
  r8 b,,16_2 b r8 b |
  r \aIIIch \fingPos #'(0 . 1.2) e_._5[ b_._2] r |
  r b16 b r8 b |
  \barRestCentre R1 * 4/8 |
  \fingOff } \fingOn \clef treble |\bar "||"\break
  
  \rhBi_xii
  
  g''4 a |
  \set fingeringOrientations = #'(left)
  \stemDown 
  \shape #'((0 . 0.5) (1 . 1.5) (1.5 . 2) (0 . -3)) Slur
  \bVIsh b16( a g \csl <e-1>) \beamPos #'(8 . 8.3) d8^. \csr <e-5>^. |
  \beamPos #'(-7.7 . -8.3) 
  \shape #'((0 . 0.5) (1 . 1.5) (1 . 2.5) (0 . -0.5)) Slur
  d16( b g \csl \fingPos #'(0 . 1.8) e_2) \stemDown \bIIIhc d8^. e^.  |
  \csr \stemUp \ohs 
  \shape #'((0 . -0.2) (0 . -1.5) (0 . -0.5) (0 . 0)) Slur
  fs16_2_( g_1 a b  \stemUp \aIIhs c_1 d e fs |
  g2) |\bar"||" \break
  \key c \major
  
  s2 |
  \stemNeutral r16 \bIIsc e'8^>^5( d16 \aIIIsc c \fingPos #'(0 . 1) a_2 g8_1) |
  s2 |
  r16 \bIIch e'8^>^5( c16 d8~^4) <f,_1 d'> |
  s1 * 1/2 |%\break \pageBreak
  r16 \bIIsc e'8^>( d16 \aIIIsc c a g8) |
  r4 \aIIcs g8_._2 <f a>_. |\pageBreak
  <e c'> r s s |
  s2 |
  r16 \osc e''8^>( d16 \och c a g8) |
  s2 |
  r16 \osc e'8^>( c16 \och d8~) <f, d'> |
  s2 |
  r16 \osc e'8^>( d16 \och c a g8) |
  r4 \bIch g8^.^5 e^. |
  c2 |
  a4_2 \aIIIhs g16( a c8) |
  a2 |
  a4 \aIIIhs g16( a c8) |
  e2 |
  a,4 \aIIIhs g16( a c8) |
  a2 |
  e4_5( \och d8 c) |
  a2 |
  s2 |
  r16 \bIIsc e''8^>( d16 \aIIIsh c a g8) |
  s2 |
  r16 \bIIch e'8^>( c16 d8~) <f, d'> |
  s2 |
  r16 \bIIsc e'8^>( d16 \aIIIsh c a g8) |
  r4 \aIIcs g8_. <f a>_. |
  <e c'>2 |\break
  d'16^2( e^3 \csl fs,_4 c'_1 \csr \bIIhs d e a8) |
  \barRestCentre R1 * 1/2 |
  d,,16^2( e^3 \csl fs,_4 c'_1 \csr \stemNeutral \aIIhs d e a8) |
  R1 * 1/2 |
  r16 \aIhc \slurShapeBlxxxv a,_1( b c \aIIhs d_1 e fs g_1 |
  \bIIIhs a b c^1 d \bIIhs e fs g^1 a) |
  \bar "||"
  \key g \major
  \grace s256 
  
}

left = \relative c' {
  \global
  << 
    {
      \stemNeutral 
      \override Rest.staff-position = 0
      \override MultiMeasureRest.staff-position = 0
      \distanceBetweenBeams
      \once \hideNotes\grace { b64 }
  
      \lhBi_xii
  
      r8 \bIIch <g b d>[ r <fs a d>] |
      \repeat unfold 3 { r \bIIhc <e g b>[ r <e a c>] } |
      r \bIIhs <e g b>[ r <a cs>] |
  
      r8*1/2 s \ocs <b-4 d-2 e-1>8[ c\rest <c!-3 e-1>]
      \repeat unfold 3 { r \ocs <b d e>[ c\rest <c e>] } \clef treble |
  
      \accidOn \fingOn
      r8 \aIIIcs <d-5 g-2 b-1>[ r <e-4 g-2 b-1>]
      r8 \aIIIcs <d g b>[ r <e g b>]
      \clef bass |
      
      r \bIIc <e, g cs>[ r <fs c'>] |
      r <g-2 b-1>^. <g, d'>4 |
  
      \repeat unfold 2 {
        e8_2[ e\rest e] r |
        r4 r8 b_._5 |
        e8[ e\rest e] r |
        r \ohc b_.[ e_.] r |\fingOff
      } \fingOn 
  
      \lhBi_xii % repeat of bars 1 to 12
  
      r8 \bIIch <g' b d>[  r <g a cs>] |
      s1 * 1/2 * 2 |
      r4 <d fs> |
      <g b>8^. r <g, d'>4_- |
  
      \key c \major
      \set fingeringOrientations = #'()
      \lhBxxxxix
      \stemNeutral <c g'>4. a'8^1 |
      \lhBxxxxix
      \set fingeringOrientations = #'(left)
      \stemNeutral <c, g'>4. <a'-2 b-1>8^. |
      \lhBxxxxix
      \stemNeutral <c, g'>4. a'8 |
      \shape #'((0 . 0) (0 . 0.7) (0 . 0.7) (0 . 0)) Slur
      \bIIhs \fingPos #'(-0.7 . -1.2) g16^5( a^4 c^2 e^1) r8 <g, b> |
  
      \stemDown d16\rest \bIIIhc c( d e \csr 
      \set fingeringOrientations = #'(left)
      \ohs \stemUp <f-1> g a b) | 
      
      \csl
      \clef treble
      \transpose c c' { \fingOff \lhBxxxxix } | 
      \stemNeutral <c e g>4. a'8 |
      \transpose c c' { \fingOff \lhBxxxxix } |
      <c, e g>4. <a' b>8_. |
      \transpose c c' { \fingOff \lhBxxxxix | }
      <c, e g>4. a'8 \fingOn |
      \stemNeutral \bIVhs g16_5( a c e) r8 <f,_2 a_1>^( |
      \aIIch <e_3 g_1> <d f> <c e>4) \clef bass |
  
      \set fingeringOrientations = #'(left)
      r8 <c-2 e-1>^. a4^4 |
      r8 e^._2 a,4_5 
      \repeat unfold 2 {
         r8 <c' e>^. a4 |
         r8 e^. a,4 
      } |
  
      r8 e'^2[( f e]) |
      <a, c>2 \fingOff |
      \lhBxxxxix
      \stemNeutral <c g'>4. a'8 |
      \lhBxxxxix
      \stemNeutral <c, g'>4. <a' g>8 |
      \lhBxxxxix
      \stemNeutral <c, g'>4. a'8 |
      \bIIhs g16( a c e) r8 <g, b> |
      \fingOn
      r g^. c,4_> \clef treble |
      s4 r |
      r8 \aIIsh a''_._2[ d,_-_5] r \clef bass |
      s4 \parenthesize r |
      r8 \bIIsh a^.^2[ d,^-^5] r \clef bass |
      R1 * 1/2 |
      \barRestCentre R1 * 1/2 \clef treble |
 
      \key g \major
      \grace s256
     }
     \\
     \relative c' {
       s2 * 55 |
       s4 d,\rest | s2 * 5 |
       s2 * 25 |
     }
  >>
}

dynamics = { 
  \spaceBetween_xiiPv
  s2 * 3\mf | s4 \scoreSlurShapeBiv s |
  
  \spaceBetween_xiiPv
  s2 * 2 |
  \scoreBeamPos #'(-5.7 . -6.3) \scoreSlurShapeBviia s4 
  \scoreBeamPos #'(-6.7 . -7.3) \scoreSlurShapeBviib s |
  \once \override Hairpin.shorten-pair = #'(0 . 1)
  \once \override DynamicLineSpanner.Y-offset = -7
  \hairpinWhiteOut
  \scoreBeamPos #'(-6.7 . -7.3)
  \scoreSlurShapeBviii
  s8\> s s\! s |
  s2 |
  
  \spaceBetween_xiiiPv
  s2 * 2 |
  \once \override DynamicLineSpanner.Y-offset = 0
  s2\< |
  s2\! |
  s2 |
  
  \spaceBetween_xivPv
  s2 * 2 |
  s2 * 2\p |
  \once \override DynamicText.X-offset = 0
  s2\mp |
  
  \spaceBetween_xiiiPv
  s\> |
  s4\! 
  \hairpinWhiteOut
  s\< |
  s2 |
  s\! |
  s8\> s s s\!|
  
  \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (13.5))(Y-offset . 6))    
  s2 * 8\mp |
  
  \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (14.5))(Y-offset . 34))
  s2 * 3\!\mf | s4 \scoreSlurShapeBxxxvi s | s2 |\break
  
  \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (14.5))(Y-offset . 69.8))
%             (alignment-distances . (14.5))
  s2 |
  \scoreBeamPos #'(-5.7 . -6.3) \scoreSlurShapeBxxxixa s4 
  \scoreBeamPos #'(-7.7 . -8.3) \scoreSlurShapeBxxxixb s | 
  \override Score.Fingering.stencil = #'()
  \once \override Hairpin.shorten-pair = #'(0 . 1)
  \once \override DynamicLineSpanner.Y-offset = -7
  \hairpinWhiteOut
  \scoreBeamPos #'(-8.7 . -9.3) \scoreSlurShapeBxl s8\> s s\! s |
  s2 * 2 |
  
  \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (14.5))(Y-offset . 102))
  s2 |
  \revert Score.Fingering.stencil
  s8\< s s s\! |
  s2 * 2 |
  s4 s16\< s s s\! |
  s2 |
  
  \overrideProperty Score.NonMusicalPaperColumn.line-break-system-details
             #'((alignment-distances . (14.5))(Y-offset . 132.5))
             \once \override DynamicText.Y-offset = 0
  \scoreBeamPosAtBxxxix s4\mp \scoreBeamPosAtBxxxix s | s2 | 
  \scoreBeamPosAtBxxxx s4 \scoreBeamPosAtBxxxx s | s2 |
  \once \override DynamicText.X-offset = 0
  \once \override DynamicLineSpanner.Y-offset = 1
  \scoreBeamPosAtBxxxix s4\mf \scoreBeamPosAtBxxxix s | s2 | 
  s2 |
  
  \spaceBetween_xiiiPv
  s16 \scoreSlurShapeBlvi s s s s\< s s s\! |
  \scoreBeamLow s8\f 
  \once \override DynamicText.X-offset = 1
  s\p \scoreBeamLow s s |
  s2 | \scoreBeamHigh s4 \scoreBeamHigh s | s2 |
  \once \override DynamicText.X-offset = 0
  \scoreBeamLow s4\mf 
  \scoreBeamLow s |
  
  \spaceBetween_xivPv
  s2 |
  s16\< s s s\! s8 \hairpinWhiteOut s\> |
  s s s s\! |
  \once \override DynamicText.X-offset = 0
  s2 * 3\mp |
  
  s2 *3 |
  s8\> s s s\! |
  s2 |
  \once \override DynamicText.X-offset = 0.2
  \scoreBeamLow  s4\f 
  \scoreBeamLow s | s2 |
  
  \repeat unfold 2 { \scoreBeamHigh s4 \scoreBeamHigh s | s2 | }
  s2 * 2 |  
  
 \scoreBeamPos #'(-5.7 . -6.3)
  s4 s | s2 | \scoreBeamPos #'(-7.7 . -8.3) s4 s | s2 |
  s16 s-"cresc." s s s4 |
  s s16 s s-"D.C." s |
}

\score {
  \new PianoStaff \with {
    instrumentName = ""
  } <<
    \new Staff = "right" \with {
      midiInstrument = "acoustic grand"
      \basicSpaceBetween 
    } \right
    \new Dynamics = "Dynamics_pf" \dynamics
    \new Staff = "left" \with {
      midiInstrument = "acoustic grand"
    } { \clef bass \left }
  >>
  \layout {  }
}

